<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Response;
use Validator;
use Mail;

class FeedbackController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('includes.contact-us')->render();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /** @var $rules - form validation */
        $rules = [
            'name' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
            'message' => 'required',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Response::json($validator->errors(), 422);
        }

        /** Send e-mail on info@castle-familyoffice.sg */
        $success = false;

        $name_field = $request->get('name');
        $location_field = $request->get('location');
        $phone_field = $request->get('phone');
        $email_field = $request->get('email');
        $message_field = $request->get('message');
        $mail_admin = 'info@castle-familyoffice.sg';
        $data = [
            'name' => $name_field,
            'location' => $location_field,
            'phone' => $phone_field,
            'email' => $email_field,
            'subject' => 'Feedback from Contact Us form at castle-familyoffice.sg',
            'content' => $message_field,
            'from' => $mail_admin,
        ];

        Mail::send('requests.feedback', $data, function ($message) use ($data) {
            $message->from($data['from'], 'Castle Family Office');
            $message->to('info@castle-familyoffice.sg');
            $message->subject($data['subject']);
        });

        $success = true;

        if ($success) {

            Session::flash('success', 'Success');

            return Response::json($success, 200);
        } else {
            Response::json(['There is an error while sending an e-mail'], 422);
        }
    }
    public function success()
    {
        return view('includes.success')->render();
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
