<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Response;
use Validator;
use Mail;
use File;

class QuickApplyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('includes.quick-apply')->render();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /** @var $rules - form validation */
        $rules = [
            'name' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
            'cv_file' => 'required|mimes:doc,docx,txt,pdf|max:4096',
        ];
        //dd($rules);
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {

            return Response::json($validator->errors(), 422);
        }

        /** Send e-mail on info@castle-familyoffice.sg */
        $success = false;

        $client_type_field = $request->get('client_type');
        $name_field = $request->get('name');
        $phone_field = $request->get('phone');
        $email_field = $request->get('email');
        $message_field = $request->get('message');
        $cv_file = $request->file('cv_file');
        $mail_admin = 'info@castle-familyoffice.sg';
        $data = [
            'clientType'  => $client_type_field,
            'name' => $name_field,
            'phone' => $phone_field,
            'email' => $email_field,
            'subject' => 'Feedback from Quick Apply form at castle-familyoffice.sg',
            'content' => $message_field,
            'cv_file' => $cv_file,
            'from' => $mail_admin,
        ];

        Mail::send('requests.quick-apply', $data, function ($message) use ($data) {
            $message->from($data['from'], 'Castle Family Office');
            $message->to('info@castle-familyoffice.sg');
            $message->subject($data['subject']);
            $message->attachData(File::get($data['cv_file']), str_slug($data['name'] . '_cv') . '.' . $data['cv_file']->getClientOriginalExtension(), ['mime' => $data['cv_file']->getMimeType()]);
        });

        $success = true;

        if ($success) {

            Session::flash('success', 'Success');

            return Response::json($success, 200);
        } else {
            Response::json(['There is an error while sending an e-mail'], 422);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
