<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use App\Page;


class ToUCheckController extends Controller
{
    public function getPageData ($slug){
        $pageData = Page::where('slug', $slug)->first();
        $pageData = $pageData->translate('locale',  app()->getLocale() );
        return $pageData;
    }

    public function index(Request $request)
    {
        $touCheckFlag = session('touCheck');
        if (view()->exists('tou')) {
            return view('tou')->with('pageData', $this->getPageData('terms-of-use'));;
        }
    }

    public function submit(Request $request)
    {
        if (count($_COOKIE) > 0) { //check if cookies are enabled (Laravel must sets some before)
            //  dd('cookies are enable!');
            setcookie("touCheck", 'true', time() + (90 * 24 * 60 * 60)); // set cookie for 3 months
        }
        session(['touCheck' => 'true']); //set session flag to true anyway
        $touCheckFlag = session('touCheck');
        $touPrevPage = session('touPrevPage');
        if ($touCheckFlag == 'true') {
            if ($touPrevPage != ''){
                session(['touPrevPage' => '']); // reset session key
                return redirect()->route($touPrevPage);
            }
            else {
                return redirect()->route('home');
            }
        } else {
            return redirect()->route('tou');
        }
    }
}


