<?php

namespace App\Http\Middleware;

use Closure;

class Locale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ($request->method() === 'GET') {
            $segments = $request->segments();
            $segment = $request->segment(1);
            $defaultLang =  config('app.fallback_locale');  // define default locale TODO add checking fallback_locale in locales array
            if (!in_array($segment, config('app.locales'))) {
                session(['locale' => $defaultLang]);
                app()->setLocale($defaultLang);
            }
            elseif ($segment == $defaultLang) {
                array_shift($segments); //remove /$defaultLang/ from URI
                session(['locale' => $defaultLang]);
                app()->setLocale($defaultLang);
                return redirect()->to(implode('/', $segments));
            }
            else {
                session(['locale' => $segment ]);
                app()->setLocale($segment );
            }
        }
        return $next($request);
    }
}