<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

$lang = Request::segment(1);  //array begins from 1
if (in_array($lang, ['ru', 'zh'])) {
    App::setLocale($lang);
} else {
    $lang = null;
}

Auth::routes();

Route::group(['prefix' => $lang, 'middleware' => ['locale', 'tou']], function () {
    Route::get('/', ['as' => 'home', 'uses' => 'PagesController@home']);
    Route::get('/choose-client-type', ['as' => 'choose-client-type', 'uses' => 'PagesController@chooseTypeForm']);

    Route::get('/about-us', ['as' => 'about-us', 'uses' => 'PagesController@aboutUs']);
    Route::get('/history', ['as' => 'history', 'uses' => 'PagesController@aboutUs']);
 //   Route::get('/career', ['as' => 'career', 'uses' => 'PagesController@career']);
    Route::get('/services', ['as' => 'services', 'uses' => 'PagesController@aboutUs']);
    Route::get('/media', ['as' => 'media', 'uses' => 'PagesController@aboutUs']);
    Route::get('/login', function () {
        return redirect('https://crm.castle-familyoffice.com/login');
    })->name('login');

    Route::get('/contact-us', ['as' => 'contact-us', 'uses' => 'PagesController@contactUs']);

    Route::group(['prefix' => 'private-wealth', 'middleware' => ['locale', 'tou']], function () {
        Route::get('/', ['as' => 'private-wealth', 'uses' => 'PagesController@privateWealth']);
        Route::get('/private-wealth', ['as' => 'private-wealth.private-wealth', 'uses' => 'PagesController@privateWealth']);
        Route::get('/trust-and-estate-planning', ['as' => 'private-wealth.trust-and-estate-planning', 'uses' => 'PagesController@trustAndEstatePlanning']);
        Route::get('/assets-ownership', ['as' => 'private-wealth.assets-ownership', 'uses' => 'PagesController@assetsOwnership']);
        Route::get('/real-estate-investment-and-management', ['as' => 'private-wealth.real-estate-investment', 'uses' => 'PagesController@realEstateInvestment']);
        Route::get('/foreign-residence-and-citizenship', ['as' => 'private-wealth.foreign-residence-and-citizenship', 'uses' => 'PagesController@foreignResidence']);
    });

    Route::group(['prefix' => 'legal-support', 'middleware' => ['locale', 'tou']], function () {
        Route::get('/', ['as' => 'legal-support', 'uses' => 'PagesController@legalSupport']);
        Route::get('/legal-support', ['as' => 'legal-support.legal-support', 'uses' => 'PagesController@legalSupport']);
        Route::get('/regulatory-and-compliance', ['as' => 'legal-support.regulatory-and-compliance', 'uses' => 'PagesController@regulatoryAndCompliance']);
        Route::get('/contracts-and-commercial', ['as' => 'legal-support.contracts-and-commercial', 'uses' => 'PagesController@contractsAndCommercial']);
        Route::get('/governance-and-risk', ['as' => 'legal-support.governance-and-risk', 'uses' => 'PagesController@governanceAndRisk']);
        Route::get('/tax-planning', ['as' => 'legal-support.tax-planning', 'uses' => 'PagesController@taxPlanning']);
    });

    Route::group(['prefix' => 'corporate-services', 'middleware' => ['locale', 'tou']], function () {
        Route::get('/', ['as' => 'corporate-services.succession-planning', 'uses' => 'PagesController@successionPlanning']);
        Route::get('/succession-planning', ['as' => 'corporate-services.succession-planning', 'uses' => 'PagesController@successionPlanning']);
        Route::get('/incorporation-and-administration-of-companies', ['as' => 'corporate-services.incorporation-and-administration-of-companies', 'uses' => 'PagesController@incorporationAndAdministrationCompanies']);
        Route::get('/establishment-management-and-administration-of-trusts', ['as' => 'corporate-services.establishment-management-and-administration-of-trusts', 'uses' => 'PagesController@establishmentManagementAndAdministrationTrusts']);
        Route::get('/accounting-and-tax-packages-for-companies', ['as' => 'corporate-services.accounting-and-tax-packages-for-companies', 'uses' => 'PagesController@accountingAndTaxPackagesForCompanies']);

    });

    Route::group(['prefix' => 'career', 'middleware' => ['locale', 'tou']], function () {
        Route::get('/', ['as' => 'career', 'uses' => 'VacanciesController@index']);
   //     Route::get('/quick-apply/create', ['as' => 'career.quick-apply.create', 'uses' => 'VacanciesController@create']);
   //     Route::post('/quick-apply/store', ['as' => 'career.quick-apply.store', 'uses' => 'VacanciesController@store']);
        Route::get('/choose-country/{country}', ['as' => 'career.choose-country', 'uses' => 'VacanciesController@chooseCountry']);
        Route::get('/{country}', ['as' => 'career.view-country', 'uses' => 'VacanciesController@viewCountry']);
       Route::get('/{country}/{vacancy}', ['as' => 'career.view-vacancy', 'uses' => 'VacanciesController@viewVacancy']);

    });
    Route::get('quick-apply/success', 'FeedbackController@success');
    Route::resource('quick-apply', 'QuickApplyController');

    Route::get('feedback/success', 'FeedbackController@success');
    Route::resource('feedback', 'FeedbackController');

    Route::get('individual-client/success', 'FeedbackController@success');
    Route::resource('individual-client', 'IndividualClientController');

    Route::get('corporate-client/success', 'FeedbackController@success');
    Route::resource('corporate-client', 'CorporateClientController');

    Route::get('terms-of-use', ['as' => 'terms-of-use', 'uses' => 'PagesController@termsOfUse']);
    Route::get('privacy-policy', ['as' => 'privacy-policy', 'uses' => 'PagesController@privacyPolicy']);
    Route::get('cookies-policy', ['as' => 'cookies-policy', 'uses' => 'PagesController@cookiesPolicy']);

    Route::get('tou', ['as' => 'tou', 'uses' => 'ToUCheckController@index']);
    Route::post('tou', ['as' => 'tou.submit', 'uses' => 'ToUCheckController@submit']);

    Route::get('media', ['as' => 'media', 'uses' => 'MediaController@index']);
    Route::get('our-media-coverage', ['as' => 'media.media-coverage', 'uses' => 'MediaController@mediaCoverage']);
    Route::get('market-update', ['as' => 'media.market-update', 'uses' => 'MediaController@marketUpdate']);
    Route::get('media/{slug}', ['as' => 'media.view-post', 'uses' => 'MediaController@viewPost']);

});

Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
});
