<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#303030">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <title><?php echo $__env->yieldContent('title'); ?> - Castle Family Office</title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500&amp;subset=cyrillic" rel="stylesheet">

    <link href="<?php echo e(mix('css/app.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(mix('css/intlTelInput.css')); ?>" rel="stylesheet" type="text/css">
<?php echo $__env->yieldContent('css'); ?>
<!-- Scripts -->
    <?php echo $__env->yieldContent('js'); ?>
</head>
<body class="page">
<?php $__env->startSection('header'); ?>
    <header class="header page__header">
        <div class="nav-menu header__nav-menu">
            <a href="<?php echo e(route('home')); ?>" class="nav-menu__logo"></a>
            <p class="nav-menu__title">Castle Family Office</p>
            <?php if ($__env->exists('includes.langSwitcher')) echo $__env->make('includes.langSwitcher', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="nav-menu__button">
                <button type="button" class="button button_nav-menu nav-logo__button" data-toggle="collapse"
                        data-target=".nav-menu_mobile">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="button__icon-bar"></span>
                    <span class="button__icon-bar"></span>
                    <span class="button__icon-bar"></span>
                </button>
                <div class="nav-menu__button nav-menu__button_close"></div>
            </div>
            <?php echo menu('Main', 'layouts.main-menu'); ?>

        </div>
    </header>
<?php echo $__env->yieldSection(); ?>

<?php echo $__env->yieldContent('content'); ?>

<?php $__env->startSection('footer'); ?>
    <footer class="footer footer_<?php echo e(app()->getLocale()); ?> page__footer">

        <div class="footer__links">
            <div class="footer__social">
                <a href="https://www.linkedin.com/groups/8727439/" target="_blank"
                   class="footer__social-link footer__social-link_linkedin"></a>
                <a href="#" target="_blank"
                   class="footer__social-link footer__social-link_telegram"></a>
                <a href="#" target="_blank"
                   class="footer__social-link footer__social-link_facebook"></a>
            </div>
            <div class="footer__logos">
                <img src="/images/award_sign_small.png" alt="" class="footer__logo footer__logo_award-sign">
                <img src="/images/comodo-secure-icon.png" alt="" class="footer__logo footer__logo_comodo">
            </div>
        </div>
        <div class="footer__text">
            <div class="divider footer__divider"></div>
            <p class="footer__copyright">Copyright © 2019 Castle Family Office. All rights reserved.</p>
            <div class="policies footer__policies">
                <a href="<?php echo e(route('privacy-policy')); ?>" class="policies__link">Privacy Policy</a>
                <span class="policies__link-divider">|</span>
                <a href="<?php echo e(route('terms-of-use')); ?>" class="policies__link">Terms of use</a>
                <span class="policies__link-divider">|</span>
                <a href="<?php echo e(route('cookies-policy')); ?>" class="policies__link">Cookies Policy</a>
            </div>
            <p class="footer__reg-no">Knightsbridge Capital Markets Pte Ltd, a company registered in the Republic of
                Singapore (Reg No. 201621967C).</p>
            <p class="footer__trademark">Castle is a trademark for Knightsbridge Capital Markets Pte. Ltd, a company
                registered in the Republic of Singapore (Reg No. 201621967C).</p>
        </div>

    </footer>
<?php echo $__env->yieldSection(); ?>
<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>
</body>
</html>