import '@fancyapps/fancybox/dist/jquery.fancybox.min.js';
import '@fancyapps/fancybox/dist/jquery.fancybox.min.css';
import 'intl-tel-input';
import 'intl-tel-input/build/css/intlTelInput.css';


$(document).ready(function () {
    if ($(".nav-menu__button")) {
        $(".nav-logo__button").on('click', function (event) {
            if (window.innerWidth <= 820) {
                $('.nav-menu').addClass('nav-menu_active');
                $('.lang-switcher').addClass('lang-switcher_active-menu');
            }
        });
        $(".nav-menu__button_close").on('click', function (event) {
            if (window.innerWidth <= 820) {
                $('.nav-menu').removeClass('nav-menu_active');
                $('.lang-switcher').removeClass('lang-switcher_active-menu');
            }
        });
    }

    $(".nav-menu__item[data-item-name]").on("click", function (event) {
        var menuName = $(this).attr("data-item-name");
        if ($(".nav-menu__submenu_active").length > 0) {  //если активно другое подменю, закрываем его
            $(".nav-menu__submenu_active").each(function () {
                if ($(this).parent().attr("data-item-name") !== menuName) {
                    $(this).removeClass('nav-menu__submenu_active');
                }
            });
        }
        $(this).find('.nav-menu__submenu').toggleClass('nav-menu__submenu_active');
    });



    var lang = document.getElementsByTagName("html")[0].getAttribute("lang");
    var elements = $('.lang-switcher').find('.lang-switcher__item');
    $.each(elements, function (index, element) {
        if ($(element).data("lang") == lang) {
            $(element).addClass('lang-switcher__item_active');
        }
    });

    window.onscroll = function () {
        var scrolled = window.pageYOffset || document.documentElement.scrollTop;
        if (scrolled !== 0) {
            $('.page__header').addClass('page__header_scrolled');
            $('.page__content').addClass('page__content_scrolled');

        }
        else {
            $('.page__header').removeClass('page__header_scrolled');
            $('.page__content').removeClass('page__content_scrolled');
        }
        //  document.getElementById('showScroll').innerHTML = scrolled + 'px';
    };

    $.fn.isInViewport = function () {
        var elementTop = $(this).offset().top;
        var elementBottom = elementTop + $(this).outerHeight();
        var viewportTop = $(window).scrollTop();
        var viewportBottom = viewportTop + $(window).height();
        // console.log('el_bottom: '+elementBottom+ ' el_top: '+elementTop+' vt: '+viewportTop+' vb: '+viewportBottom);
        return elementBottom > viewportTop && elementTop < viewportBottom;
    };


    $(window).on('resize scroll', function () {
        if ($('.footer').isInViewport()) {
            //console.log('footer is here!');
            if ($('.disclaimer__button-wrapper_fixed').length) {
                $('.disclaimer__button-wrapper').removeClass("disclaimer__button-wrapper_fixed")
            }
        }
        else {
            if ($('.disclaimer__button-wrapper').length) {
                $('.disclaimer__button-wrapper').addClass("disclaimer__button-wrapper_fixed")
            }
        }
    });

    if (localStorage.getItem("sendFormSuccess") == "true") {
        $.fancybox.open({src: '/' + lang + '/feedback/success', type: 'ajax'});
        localStorage.setItem('sendFormSuccess', 'false');
    }

});